#!/usr/bin/perl
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#
# Perl script to load the dumps into PostgreSQL with progress indicator and
# frequent commits.
# This scripts reads the two files generated by dumpmigrate.pl and loads
# their data into the database, showing a progress indicator while doing so.
#
# author: Alexander Schreiber <als@thangorodrim.de>
#
# CVS: $Id: loaddump.pl,v 1.2 2004/05/26 20:57:19 als Exp $
#

# changed the contents of the hash below accordingly to reflect your
# environment

%to =  (
         db => 'DATABASE',
         host => 'DATABASE_SERVER',
         user => 'USER',
         password => 'PASSWORD'
        ); 

use DBI;

sub db_connect {

    my $dsn = shift;
    my $user = shift;
    my $password = shift;

    my $dbh;

    $dbh = DBI->connect($dsn, $user, $password,
                         { RaiseError => 1, AutoCommit => 0 });

    if ( not defined ($dbh) ) {
        print STDERR "Failed to connect to database ($dsn)!\n";
        return -1;
    } else {
        return $dbh;
    }
}

# force flushed output
$| = 1;

$dsn = "dbi:Pg:dbname=$to{db} host=$to{host}";
$dbh = &db_connect($dsn, $to{user}, $to{password});

open(HOSTS, "<hosts-dump.sql") or die "Cannot open hosts-dump.sql";

$counter = 0;
print "loading host entry: 0000000000";
while ( $line = <HOSTS> ) {
    chomp($line);
    if ( $line =~ /^(\d+)\t(\S+)$/ ){
        $sql = "INSERT INTO hosts (id, hostname) values ($1, '$2')";
        $sth = $dbh->prepare($sql);
        $sth->execute;
        $counter++;
        if ( ($counter % 1000) == 0 ) {
            $dbh->commit;
            print "\b\b\b\b\b\b\b\b\b\b";
            printf("%10d", $counter);
        }
    }
}
$dbh->commit;
print " hosts done.\n";

close(HOSTS);

open(TRAFFIC, "<traffic-dump.sql") or die "Cannot open traffic-dump.sql";

$counter = 0;
print "loading traffic entry: 0000000000";
while ( $line = <TRAFFIC> ) {
    chomp($line);
    if ( $line =~ /^\S+\s+(\S+)\s+(\S+)\s+(\d+)\s+(\d+)\s+(\d+)$/ ) {
        $sql  = "INSERT INTO trafficentries (date, time, host, incoming, ";
        $sql .= "outgoing) values (";
        $sql .= "'$1', '$2', $3, $4, $5)";
        $sth = $dbh->prepare($sql);
        $sth->execute;
        $counter++;
        if ( ($counter % 1000) == 0 ) {
            $dbh->commit;
            print "\b\b\b\b\b\b\b\b\b\b";
            printf("%10d", $counter);
        }
    }
}
$dbh->commit;
print " traffic done.\n";
close(TRAFFIC);

