#!/usr/bin/perl -w
# This script is used to establish a TCP connection with a host to get the
# disk info provided by showdisk.pl.
#
# use: ./getdisk.pl <hostname> <mount point>
#
# $Id: getdisk.pl,v 1.3 2002/08/14 17:00:43 als Exp $
#
# By Steven Micallef <smic@wire.net.au> on the 24/4/1999.
#
# Modified by Alexander Schreiber <als@thangorodrim.de> to adapt to the
# changes in showdisk.pl. Now uses mount point instead of disk number.
# Added "use strict" and rewrote to script to comply with this.
#

use Net::Telnet ();
use strict;

my ($hostname, $mount_point, $t, $data, $found, $port);

$hostname = $ARGV[0];
$mount_point = $ARGV[1];

# If you've changed the port showdisk.pl runs on, change it here too.
$port = 40000;


if ( scalar(@ARGV) != 2 )
{
  print "Usage: $0 <hostname> <mount point>\n";
  exit;
}

$t = new Net::Telnet ( Host => $hostname, Port => $port);
$t->open("$hostname");

$found = 0;
while ( $data = $t->getline(Timeout => 40) ) {
    if ( $data =~ /^$mount_point\s+(\d+)$/ ) {
        print "$1\n0\n0\n";
        $found = 1;
    }
}

if ( $found == 0 ) {
    print "0\n0\n0\n";
}

